﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Get Vista Integration Result step.
    /// </summary>
    public class GetVistaIntegrationResultStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            if (!state.IsGroupAppointment || state.RequestMessage.VisitStatus != VistaStatus.CANCELED.ToString()) return;

            if (!state.VistaIntegrationResultId.HasValue) throw new Exception("For Group Cancel a Vista Integration Result is required");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.VistaIntegrationResult = srv.cvt_vistaintegrationresultSet.FirstOrDefault(x => x.Id == state.VistaIntegrationResultId.Value);
                if (state.VistaIntegrationResult == null) throw new Exception($"Group Cancel: Cannot find Vista Integration Result: {state.VistaIntegrationResultId.Value}");
            }
        }
    }
}